import React, {useState, useEffect} from 'react';
import {FlatList, I18nManager, View } from 'react-native';
import { settingStyle } from './SettingStyle'
import * as Updates from 'expo-updates';
import BackNavigation from '../../Utilities/CustomHeader/BackNavigation'
import { useSelector, useDispatch } from 'react-redux';
import { setLanguage } from '../../../redux/slices/language/language';
import useLangTranslation from '../../../hooks/useLangTranslation';
import IndividualLanguage from './IndividualLanguage';
import { DEFAULT_LANG, DEFAULT_LANG_FOR_RTL, RTL_APPLICABLE_LANGUAGES } from '../../../src/constants/languageConst';
import i18n from '../../../src/language/i18n';
import {languages} from "../../../src/language/languages"


const SelectLanguage = (props) => {
    const { trans } = useLangTranslation()
    const dispatch = useDispatch();
    const { lng } = useSelector((state) => state.languageReducer);
    const [selectedId, setSelectedId] = useState(lng || 'en');

    useEffect(() => {
        dispatch(setLanguage(selectedId));
    }, [selectedId, dispatch]);

    const handleSelectLanguage = (langCode = DEFAULT_LANG) => {
      i18n.changeLanguage(langCode)
      .then(async() => {
        I18nManager.forceRTL(langCode == DEFAULT_LANG_FOR_RTL);
        if(langCode == RTL_APPLICABLE_LANGUAGES || I18nManager.isRTL) {
          try{
            await Updates.reloadAsync()
          } catch (e) {}
        }
      });
      setSelectedId(langCode);
      dispatch(setLanguage(langCode));
    }

  return (
    <View style={settingStyle.settingRoot}>
      <BackNavigation
          navigationProps={props.navigation}
          routeName={trans("select language")}
          capitalize={false}
      />
      <View style={settingStyle.hrLine} />
      <View style={settingStyle.container}>
          <FlatList
            data={languages}
            renderItem={({item}) => <IndividualLanguage 
              item={item}
              selectedId={selectedId}
              handleSelectLanguage={handleSelectLanguage}
            />}
            keyExtractor={item => item.langCode}
            extraData={selectedId}
          />
      </View>
    </View>
  )
}

export default SelectLanguage
